<?php
/**
* Language file variables. These are used all over the place - menus, paging, searching, templates, newsletters and so on.
*
* @see GetLang
*
* @version     $Id: language.php,v 1.153 2008/02/22 04:45:13 chris Exp $
* @author Chris <chris@interspire.com>
*
* @package SendStudio
* @subpackage Language
*/

define('LNG_EmailAddress', 'Email Address');

define('LNG_ControlPanel', "Control Panel");
define('LNG_Statistics', "Statistics");
define('LNG_Forms', 'Website Forms');
define('LNG_Settings', "Settings");
define('LNG_Go', 'Go');
define('LNG_ShowHelp', 'Help');
define('LNG_HideHelp', 'Hide Help');
define('LNG_Logout', 'Logout');
define('LNG_To', 'To');
define('LNG_From', 'From');
define('LNG_N/A', 'N/A');

define('LNG_Action', 'Action');

define('LNG_ViewAll', 'View All');

define('LNG_Page', 'Page');
define('LNG_Of', 'of');

define('LNG_GoToFirst', 'Go To First Page');
define('LNG_GoToLast', 'Go To Last Page');

define('LNG_Delete_Selected', 'Delete Selected');

define('LNG_NumberFormat_Dec', '.');
define('LNG_NumberFormat_Thousands', ',');
define('LNG_DateFormat', 'd M Y');
define('LNG_Quickstats_DateFormat', 'd-M-Y');
define('LNG_TimeFormat', 'F j Y, g:i a');
define('LNG_UserDateFormat', 'g:i a, d M Y');
define('LNG_Stats_TimeFormat', 'g:i a');

define('LNG_Yesterday_Date', 'Yesterday');
define('LNG_Today_Date', 'Today');
define('LNG_Tomorrow_Date', 'Tomorrow');

define('LNG_Yesterday_Time', 'Yesterday @ %s');
define('LNG_Today_Time', 'Today @ %s');
define('LNG_Tomorrow_Time', 'Tomorrow @ %s');

define('LNG_ViewingResultsFor', 'Currently viewing results for');

define('LNG_Home', "Home");

define('LNG_Either_Confirmed', 'Both Confirmed and Unconfirmed');
define('LNG_Either_Format', 'Either Format');
define('LNG_Either_Status', 'Either Status');

define('LNG_Total', "Total");

define('LNG_Yes', 'Yes');
define('LNG_No', 'No');

define('LNG_ShowMore', 'Show More');
define('LNG_HideMore', 'Hide More');

define('LNG_Created', 'Created');
define('LNG_Date_Created', 'Date Created');


define('LNG_Mon', 'Mon');
define('LNG_Tue', 'Tue');
define('LNG_Wed', 'Wed');
define('LNG_Thu', 'Thu');
define('LNG_Fri', 'Fri');
define('LNG_Sat', 'Sat');
define('LNG_Sun', 'Sun');

define('LNG_Jan', 'Jan');
define('LNG_Feb', 'Feb');
define('LNG_Mar', 'Mar');
define('LNG_Apr', 'Apr');
define('LNG_May', 'May');
define('LNG_Jun', 'Jun');
define('LNG_Jul', 'Jul');
define('LNG_Aug', 'Aug');
define('LNG_Sep', 'Sep');
define('LNG_Oct', 'Oct');
define('LNG_Nov', 'Nov');
define('LNG_Dec', 'Dec');

define('LNG_HoldMouseOver', "Hold mouse over underlined text for more information");

define('LNG_PagingNext', "Next");
define('LNG_PagingBack', "Back");

define('LNG_Next', "Next >>");
define('LNG_Back', "Back");
define('LNG_ResultsPerPage',"Results per page");

define('LNG_ErrCouldntLoadTemplate', 'Unable to load template: %s');
define('LNG_PageTitle', 'Home');
define('LNG_Edit', 'Edit');
define('LNG_Delete', 'Delete');
define('LNG_Save', 'Save');
define('LNG_SaveAndExit', 'Save And Exit');
define('LNG_Cancel', 'Cancel');
define('LNG_Copy', 'Copy');

define('LNG_PasswordCurrent', 'Current password');
define('LNG_Password', 'New Password');
define('LNG_PasswordConfirm', 'Confirm New Password');
define('LNG_PasswordConfirmAlert', 'Please confirm your new password');
define('LNG_PasswordsDontMatch', 'Your passwords don\'t match. Please try again.');
define('LNG_CurrentPasswordMissing', 'Please fill in your current password.');
define('LNG_CurrentPasswordError', 'There was an error validating your current password. Please try again');

define('LNG_GoBack', 'Go Back');
define('LNG_NoAccess', 'Permission denied. You do not have access to this area or to perform the action requested. Please contact your administrator.');

define('LNG_ConfirmCancel', 'Are you sure you want to cancel?');

define('LNG_MyAccount', 'My Account');

define('LNG_Format_Text', 'Text');
define('LNG_Format_HTML', 'HTML');
define('LNG_Format_TextAndHTML', 'HTML and Text');


define('LNG_HTMLContent', 'HTML Content');
define('LNG_TextContent', 'Text Content');

define('LNG_HTMLPreview', 'HTML Preview');
define('LNG_TextPreview', 'Text Preview');

define('LNG_Step1', 'Step 1');
define('LNG_Step2', 'Step 2');
define('LNG_Step3', 'Step 3');
define('LNG_Step4', 'Step 4');

define('LNG_CustomFieldRequired_Popup', '* ');
define('LNG_PopupCloseWindow', '[ x Close ]');

define('LNG_View', 'View');

define('LNG_Menu_MailingLists_Bounce', 'Process Bounced Emails');

define('LNG_Menu_Templates_Title', 'Create, manage and delete your templates.');

define('LNG_Menu_Statistics_Title', 'View Statistics');
define('LNG_Menu_Statistics_Newsletters', 'Email Campaign Statistics');
define('LNG_Menu_Statistics_Users', 'User Account Statistics');
define('LNG_Menu_Statistics_Autoresponders', 'Autoresponder Statistics');

define('LNG_RSS', 'RSS');


define('LNG_Email', 'Email Address');
define('LNG_HLP_Email', 'Email Address');

define('LNG_FilterEmailAddress', LNG_Email);

define('LNG_ConfirmedStatus', 'Confirmation Status');
define('LNG_FilterConfirmedStatus', LNG_ConfirmedStatus);

define('LNG_Active', 'Active');

define('LNG_Inactive', 'Inactive');

define('LNG_Confirmed', 'Confirmed');
define('LNG_Unconfirmed', 'Unconfirmed');

define('LNG_UnableToOpenFile', 'Unable to open file \'%s\'');
define('LNG_EmptyFile', 'File \'%s\' is empty');

define('LNG_FilterSearch', 'Filter by Basic Details');

define('LNG_OK', 'OK');

define('LNG_Preview', 'Preview');
define('LNG_SelectTemplate', 'Please select a template to preview.');
define('LNG_ChooseTemplate', 'Email Template');
define('LNG_HLP_ChooseTemplate', 'Choose a pre-designed email template as the basis of your email campaign. To create a new template, use the template menu at the top of the page.');

define('LNG_Preview_Template', 'Show Larger Preview');

define('LNG_SelectAll', 'Select All');
define('LNG_UnselectAll', 'Unselect All');

define('LNG_PleaseChooseAction', 'Please choose an action first.');
define('LNG_ConfirmSubscriberChanges', 'Are you sure you want to perform the selected action? It cannot be undone.');
define('LNG_BulkAction', 'Bulk Action');
define('LNG_ChooseAction', 'Choose an action');

define('LNG_ConfirmChanges', 'Are you sure you want to perform the selected action? It cannot be undone.');
define('LNG_NextButton', 'Next &raquo;');

define('LNG_FileNotUploadedSuccessfully', 'File was not uploaded successfully. Please try again.');
define('LNG_FileNotUploadedSuccessfully_TooBig', 'File was not uploaded successfully. It may be too large to upload through your browser.');

define('LNG_None', 'None');

define('LNG_CopyPrefix', 'Copy of '); // this is used for lists, templates and newsletters.

define('LNG_MergePrefix', 'Merge of '); // this is used for lists.

define('LNG_Bounced', 'Bounced');
define('LNG_Unsubscribed', 'Unsubscribed');
define('LNG_AllStatus', 'Any Status');

define('LNG_Attachments', 'Attachments');
define('LNG_HLP_Attachments', 'To add an attachment, click the browse button and select a file from your computer. Once you\\\'ve selected a file, you can then add another attachment and so on. You can upload 5 attachments at any one time.');
define('LNG_ExistingAttachments', 'Existing Attachments:');

define('LNG_UnableToCreateDirectory', 'Unable to create directory to save attachments. Please check your server permissions or contact your administrator.');

define('LNG_FileUploadSuccessful_One', 'Successfully uploaded one file.');
define('LNG_FileUploadSuccessful_Many', 'Successfully uploaded %s files.');
define('LNG_FileUploadFailure', 'Unable to upload the following files:');
define('LNG_FileExtensionNotValid', 'File extension %s is not allowed to be uploaded.');
define('LNG_NotUploadedFile', 'This file was not uploaded through the browser.');
define('LNG_FileTooBig', 'File is too big (%s). Must be less than %s');
define('LNG_UnableToUploadFile', 'Unable to upload the file.');
define('LNG_DirectoryNotWritable', 'The destination directory \'%s\' is not writable. Please check the permissions on that directory and try again or contact your administrator.');

define('LNG_HLP_DeleteAttachment', 'Check the box to delete this attachment. The attachment will be deleted after you have saved your work. This cannot be undone.');
define('LNG_DeleteAttachment', 'Delete Attachment? ');

define('LNG_FileDeleteSuccessful_One', 'Successfully deleted one file.');
define('LNG_FileDeleteSuccessful_Many', 'Successfully deleted %s files.');
define('LNG_FileDeleteFailure', 'Unable to delete the following files:');
define('LNG_FileNotFound', 'File not found');

define('LNG_ChangeStatus_Active', 'Change Status (Active)');
define('LNG_ChangeStatus_Inactive', 'Change Status (Inactive)');

define('LNG_Status_Active', 'Active');
define('LNG_Status_Inactive', 'Inactive');
define('LNG_Status_Confirmed', 'Confirmed');
define('LNG_Status_Unconfirmed', 'Unconfirmed');

// used in forms.


define('LNG_NoTemplate', 'No Template');

define('LNG_Global', 'Global');

// used anywhere to do with lists.
define('LNG_CustomFields', 'Filter by Custom Fields');
define('LNG_CustomFields_Manage', 'View Custom Fields');

// used for preview emails.
define('LNG_SendPreview', 'Preview Your Email Campaign');

define('LNG_EnterPreviewEmail', 'Please enter an email address.');
define('LNG_NoContentToEmail', 'No content has been entered, so no preview email has been sent.');
define('LNG_NoEmailAddressSupplied', 'No email address was supplied. Please try again.');

define('LNG_PreviewEmailSent', 'A preview has been sent to the email address %s.');

define('LNG_Send', 'Send');
define('LNG_Resume', 'Resume');
define('LNG_Pause', 'Pause');

define('LNG_DefaultUnsubscribeFooter_html', '<br/><a href="%%UNSUBSCRIBELINK%%">Click here to unsubscribe</a>');
// need to use " so \n gets processed correctly.
define('LNG_DefaultUnsubscribeFooter_text', "\nClick this link to unsubscribe: %%UNSUBSCRIBELINK%%");

define('LNG_DefaultModifyFooter_html', '<br/><a href="%%MODIFYLINK%%">Click here to update your details</a>');
// need to use " so \n gets processed correctly.
define('LNG_DefaultModifyFooter_text', "\nClick this link to update your details: %%MODIFYLINK%%");

define('LNG_TimeTaken_Seconds_One', '1 second');
define('LNG_TimeTaken_Seconds_Many', '%s seconds');

define('LNG_TimeTaken_Minutes_One', '1 minute');
define('LNG_TimeTaken_Minutes_Many', '%s minutes');

define('LNG_TimeTaken_Hours_One', '1 hour');
define('LNG_TimeTaken_Hours_One_Minutes', '1 hour, %s minutes');
define('LNG_TimeTaken_Hours_Many', '%s hours');
define('LNG_TimeTaken_Hours_Many_Minutes', '%s hours, %s minutes');

define('LNG_TimeTaken_Days_One', '1 day');
define('LNG_TimeTaken_Days_One_Hours', '1 day, %s hours');
define('LNG_TimeTaken_Days_Many', '%s days');
define('LNG_TimeTaken_Days_Many_Hours', '%s days, %s hours');

define('LNG_TimeTaken_Months_One', '1 month');
define('LNG_TimeTaken_Months_One_Days', '1 month, %s days');
define('LNG_TimeTaken_Months_Many', '%s months');
define('LNG_TimeTaken_Months_Many_Days', '%s months, %s days');

define('LNG_TimeTaken_Years_One', '1 year');
define('LNG_TimeTaken_Years_Many', '%s years');

define('LNG_CronNotEnabled', 'Cron sending has not been enabled. Please speak to your administrator about setting this up.');

define('LNG_Custom', 'Custom');

define('LNG_ShowCustomFields', 'Insert a Custom Field');
define('LNG_InsertUnsubscribeLink', 'Insert Unsubscribe Link');

/** Only if Addon enabled **/
define('LNG_InsertSurveyLink', 'Insert Survey Link...');
define('LNG_SurveysInsert_Editor', 'Insert Survey Link');
define('LNG_Surveys_tinymceIModalInsert', 'Insert Survey Link');
define('LNG_Surveys_tinymceIModalCancel', 'Cancel');


define('LNG_Approve', 'Approve');
define('LNG_Approved', 'Approved');
define('LNG_Disapprove', 'Disapprove');
define('LNG_Disapproved', 'Disapproved');

define('LNG_NewsletterSubject', 'Email Subject');
define('LNG_Subject', 'Subject');
define('LNG_Name', 'Name');

define('LNG_YesFilterByCustomDate', 'Yes, filter by field \'%s\'');

define('LNG_AlreadySentTo_Heading', 'Last Send Information');
define('LNG_AlreadySentTo_SoFar', 'Sent to %s / %s so far');

// used by "manage schedule" page.
define('LNG_AlreadySentTo', ' (Sent to %s / %s)');

define('LNG_ShowFilteringOptions', 'Show Filtering Options');
define('LNG_ShowFilteringOptionsExplain', 'Yes, show filtering options on the next page');

/**
* Common custom field stuff.
* This is used by searching, exporting.
*/
define('LNG_YesFilterByDate', 'Yes, filter by date subscribed');
define('LNG_After', 'After');
define('LNG_Before', 'Before');
define('LNG_Between', 'Between');
define('LNG_Exactly', 'Exactly');
define('LNG_AND', 'AND');


define('LNG_ExportFileDeleted', 'The selected export file has been deleted.');
define('LNG_ExportFileNotDeleted', 'Export file not deleted successfully. Please try again.');

/**
* Jobs
*/
define('LNG_Waiting', 'Waiting');
define('LNG_Job_Waiting', 'Sending in');
define('LNG_Job_Complete', 'Complete');
define('LNG_Job_InProgress', 'In Progress');
define('LNG_Job_Paused', 'Paused');
define('LNG_WaitingToSend', 'Waiting to send'); // this is used if 2 cron jobs have not run yet, so we can't work out the time difference.
define('LNG_ImapSupportMissing', 'IMAP support is not available. Bounced emails cannot be processed without IMAP support.');


define('LNG_AnyList', '-- All Lists --');

/**
* Subscriber stuff.
*/
define('LNG_UserChooseFormat', 'Email Campaign Format');
define('LNG_Unknown', 'Unknown');
define('LNG_SubscribeRequestDate', 'Contact Request Date');

define('LNG_Subscriber_NotSubscribed', 'The email address \'%s\' is not subscribed to this list');

define('LNG_ViewSchedule', 'View Sending Schedule');

/**
* Handles importing / uploading of a template / newsletter / autoresponder.
*/
define('LNG_UploadedFileEmpty', 'Uploaded file is empty. Please try again.');
define('LNG_UploadedFileBad', 'Unable to upload file. Please try again.');
define('LNG_UploadFileTooBig', 'Unable to upload file. It is too large. Please try a smaller file.');

define('LNG_UploadedFileCantBeRead', 'Unable to read uploaded file. Please try again.');
define('LNG_URLIsEmpty', 'URL is empty. Please try again.');
define('LNG_URLCantBeRead', 'Unable to fetch url. Please make sure it is valid and then try again.');
define('LNG_NoCurlOrFopen', 'Unfortunately your server cannot open remote files.<br/>Please ask your system administrator to enable curl or remote fopen support.');

/**
* Used for the settings page and the users page.
*/
define('LNG_UseSMTP', 'Use SMTP Server');
define('LNG_UseSMTPExplain', 'Yes, use an SMTP server');

define('LNG_SmtpServer', 'SMTP Server');
define('LNG_HLP_SmtpServer', 'Choose to use the default SMTP server specified from the settings page, or choose to use a custom SMTP server for this client.');

define('LNG_SmtpServerIntro', 'Mail Server Details');
define('LNG_SmtpServerName', 'SMTP Hostname');
define('LNG_HLP_SmtpServerName', 'Enter the SMTP host name here, such as &quot;192.168.0.50&quot; or &quot;mail.mysite.com&quot;');
define('LNG_SmtpServerUsername', 'SMTP Username');
define('LNG_HLP_SmtpServerUsername', 'If your SMTP server requires authentication, enter the username here.');
define('LNG_SmtpServerPassword', 'SMTP Password');
define('LNG_HLP_SmtpServerPassword', 'If your SMTP server requires authentication, enter the password here.');
define('LNG_SmtpServerPort', 'SMTP Port');
define('LNG_HLP_SmtpServerPort', 'To use a non-standard SMTP port (the default is 25), enter it here.');

/**
* Used by the email class and testsmtp scripts.
*/
define('LNG_UnableToConnectToEmailServer', 'Unable to connect to mail server: %s');
define('LNG_UnableToSendEmail_MailFrom', 'Unable to set mail from address.');
define('LNG_UnableToSendEmail_RcptTo', 'Unable to set receipt to address.');
define('LNG_UnableToSendEmail_Data', 'Unable to set data.');
define('LNG_UnableToSendEmail_DataWriting', 'Unable to send data.');
define('LNG_UnableToSendEmail_DataFinished', 'Unable to send "." to server.');
define('LNG_UnableToConnectToMailServer_EHLO', 'Unable to send "EHLO" command.');
define('LNG_UnableToConnectToMailServer_RequiresAuthentication', 'Server requires authentication but no username or password has been set.');
define('LNG_UnableToConnectToMailServer_AuthLogin', 'Unable to send "auth login" to server.');
define('LNG_UnableToConnectToMailServer_AuthLoginNotSupported', 'Unable to authenticate with server. Doesn\'t support "AUTH LOGIN"');
define('LNG_UnableToConnectToMailServer_UsernameNotWritten', 'Unable to authenticate with server. Username not written.');
define('LNG_UnableToConnectToMailServer_PasswordNotWritten', 'Unable to authenticate with server. Password not written.');

/**
* Used with newsletters, templates, autoresponders, form creation
*/
define('LNG_ImportWebsite', 'Import');

define('LNG_HTML_Using_Editor', 'Create content using the WYSIWYG editor below');
define('LNG_Editor_Import_Website', 'Import a file from a web site');
define('LNG_Editor_Use_URL', 'Use an existing URL');
define('LNG_Text_Type', 'Type text into the text box below');
define('LNG_Editor_Import_File_Wait', 'Importing file, please wait...');
define('LNG_Editor_Import_Website_Wait', 'Importing website, please wait...');
define('LNG_Editor_ProblemImportingWebsite', 'There was a problem importing from the specified url. Please try again.');
define('LNG_Editor_ChooseWebsiteToImport', 'Please type in the full url of the website you want to import.');
define('LNG_Editor_ImportButton', 'Import');

/**
* Used for sending and autoresponders
*/
define('LNG_EmbedImages', 'Embed Images as Attachments?');
define('LNG_EmbedImagesExplain', 'Yes, embed images in the content');

define('LNG_SendTo_FirstName', 'My &quot;First Name&quot; Custom Field is');

define('LNG_SendTo_LastName', 'My &quot;Last Name&quot; Custom Field is');

define('LNG_SelectNameOption', 'Please select your "name" custom field');

// used all over the place with newsletters
define('LNG_CreateNewsletterButton', 'Create an Email Campaign...');
define('LNG_NoNewsletters', 'No email campaigns have been created.%s');

// used by autoresponders & stats
define('LNG_SentWhen', 'Sent');
define('LNG_Immediately', 'Immediately after signup');
define('LNG_HoursAfter_One', '1 hour after signup');
define('LNG_HoursAfter_Many', '%s hours after signup');

define('LNG_ClickedOnLink', 'Clicked On Link');
define('LNG_YesFilterByLink', 'Yes, filter by link');
define('LNG_LoadingMessage', 'Loading, please wait...');
define('LNG_FilterAnyLink', 'Any Link');

define('LNG_OpenedNewsletter', 'Opened Email Campaign');
define('LNG_YesFilterByOpenedNewsletter', 'Yes, filter by opened email campaign');
define('LNG_FilterAnyNewsletter', 'Any Email Campaign');

define('LNG_UnableToOpenPopupWindow', 'Error: Could not open required web browser window. Please check that you have disabled your popup blocker and you don\'t have Norton internet security, ZoneAlarm or any other \'security\' script that could be blocking the web browser window from opening and then try again.');



/**
* used by sending and forms.
*/
define('LNG_SendFromName', 'Send From This Name:');

define('LNG_SendFromEmail', 'Send From This Email Address');

define('LNG_ReplyToEmail', 'Send Reply Emails to');

define('LNG_BounceEmail', 'Send Bounced Emails to');

/**
* Searching custom fields.
*/
define('LNG_Filter_Number', 'Filter Number Field');

define('LNG_Filter_Checkbox', 'Filter Checkbox Field');
define('LNG_HLP_Filter_Checkbox', 'To restrict filtering of this field, tick the options you want to search for.');

define('LNG_Filter_Date', 'Filter Date Field');

define('LNG_Filter_Dropdown', 'Filter Dropdown Field');
define('LNG_HLP_Filter_Dropdown', 'To filter searching of this field, choose an option you want to search for.');

define('LNG_Filter_Radiobutton', 'Filter Radio Button Field');
define('LNG_HLP_Filter_Radiobutton', 'To filter searching of this field, choose an option you want to search for.');

define('LNG_Filter_Text', 'Filter Text Field');
define('LNG_HLP_Filter_Text', 'To filter searching of this field, type in some text that should appear. This will be found in any of the text, this does not do an exact match.');

define('LNG_Link_WebVersion', 'Web Version of Email');
define('LNG_Link_Unsubscribe', 'Unsubscribe Link');


define('LNG_SendingSystem_From', 'email@domain.com');
define('LNG_UserLimitReached', 'You have reached your maximum number of users and cannot create any more.');

define('LNG_User_OverQuota_Email', 'Hi,
This email is to notify you that user \'%s\' (email address %s) has scheduled a newsletter to go out on %s. They have gone over their %s limit by %s email(s).

%s

You can email them by clicking "Reply" in your email program.
');
define('LNG_User_OverLimit_MaxEmails', 'maximum number of emails');
define('LNG_User_OverLimit_PerMonth', 'maximum number of emails per month');
define('LNG_User_OverQuota_StoppedSend', 'The send has been disapproved.');
define('LNG_User_OverQuota_Subject', 'User over-quota notification');

define('LNG_User_OverQuota_ToUser_Email', 'Hi,
This email is to notify you that your send, scheduled to go out on %s has gone over your %s limit by %s email(s).

%s

You can email the administrator by clicking "Reply" in your email program.
');

define('LNG_User_OverQuota_ToUser_Subject', 'Over-quota notification');

/**
**************************
* Changed/Added in NX1.0.5
**************************
*/

/**
* these MUST be space separated.
* This is only used to display the date/time options when sending a newsletter
* and has to be in the correct format and only contain the 3 options mentioned:
* - 'd' for day
* - 'm' for month
* - 'y' for year
* The order does not matter but the values do.
*/
define('LNG_DateTimeBoxFormat', 'd m y');


/**
**************************
* Changed/Added in NX1.0.7
**************************
*/


/**
**************************
* Changed/Added in NX1.1.3
**************************
*/
define('LNG_PreviewEmailNotSent', 'A preview couldn\'t be sent to the email address %s: %s');


/**
**************************
* Changed/Added in NX 1.3
**************************
*/
define('LNG_TestSMTPSettings', 'Test SMTP Settings');
define('LNG_HLP_TestSMTPSettings', 'Enter an email address to send a test using the smtp details above.');
define('LNG_EnterTestEmail', 'Please enter an email address to send a test to');
define('LNG_EnterSMTPServer', 'Please enter your smtp server name to test');

define('LNG_TestSendingSubject', 'Test Email System');
define('LNG_TestSendingEmail', "Hi,\nThis is a test of the emailing system. If you received this ok, then everything is working as it should."); // this is in double quotes because of the newline.

define('LNG_SendTestIntro', 'Test Sending');
define('LNG_TestEmailAddress', 'Test Sending System');
define('LNG_HLP_TestEmailAddress', 'Enter an email address to test the sending system (uses the SMTP server details provided above if applicable).');

define('LNG_TestEmailSent', 'A test email has been successfully sent to the email address %s.');

define('LNG_TestEmailNotSent', 'A test email has not been successfully sent to the email address %s: %s');

define('LNG_UnableToLoadImage_Newsletter_List_Embed', 'Unable to load the following images to embed in the email campaign:<br/>%s');
define('LNG_UnableToLoadImage_Newsletter_List', 'Unable to load the following images in the email campaign:<br/>%s');
define('LNG_UnableToLoadImage', '- <a href="%s" target="_blank">%s</a> (%s)<br/>');

define('LNG_Bytes', ' B');
define('LNG_KiloBytes', ' KB');
define('LNG_MegaBytes', ' MB');
define('LNG_GigaBytes', ' GB');

define('LNG_GetTextContent', 'Get Text Content from Editor');

define('LNG_ImageInsert_Editor', 'Insert or Modify an Image');

define('LNG_ModifyLinkPlaceholder', 'Click here to update your details');
define('LNG_SendToFriendLinkPlaceholder', 'Click here to send this email to a friend');

define('LNG_UnableToDelete', 'Unable to delete file');


define('LNG_AllOfTheFollowing', 'All of the following');
define('LNG_AnyOfTheFollowing', 'Any of the following');

define('LNG_Menu_Templates_Create', 'Create a Custom Template');
define('LNG_Menu_Templates_Manage_BuiltIn', 'View Built In Email Templates');
define('LNG_Templates_BuiltIn', LNG_Menu_Templates_Manage_BuiltIn);

define('LNG_Menu_Newsletters_Create', 'Create an Email Campaign');
define('LNG_Menu_Newsletters_Manage', 'View Email Campaigns');
define('LNG_Menu_Newsletters_Send', 'Send an Email Campaign');
define('LNG_Menu_Newsletters_ManageSchedule', 'View Scheduled Email Queue');
define('LNG_Menu_Newsletters_Title', 'Create, view and delete your email campaigns.');

define('LNG_Menu_Autoresponders_Title', 'Create, view and delete your autoresponders.');
define('LNG_Menu_Autoresponders_Manage', 'View Autoresponders');
define('LNG_Menu_Autoresponders_Create', 'Create an Autoresponder');


define('LNG_ActiveEmailCampaignHelp', 'An email campaign can be made active and inactive. An inactive email campaign will not be allowed to be sent, while an active campaign will be allowed to be sent. You can use option if you want to create an email campaign that needs approval before it is sent where one person creates an inactive email campaign and another approves and \\\'Activates\\\' it to be sent.');

define('LNG_ActiveAutoresponderHelp', 'An email campaign can also be made active and inactive. An inactive email campaign will not be allowed to be sent, while an active campaign will be allowed to be sent. You can use option if you want to create an email campaign that needs approval before it is sent where one person creates an inactive email campaign and another approves and \\\'Activates\\\' it to be sent.');

define('LNG_HLP_SendPreview', 'Enter your email address and click the \\\'Send Preview\\\' button to receive a copy of this email. If you wish to send to multiple email addresses you can separate them by using a comma - eg email@domain.com, email2@domain.com. You can enter up to 3 email address at a time.<br/><br/>If you have uploaded new attachments, they will not be included as part of the preview email.');

define('LNG_SendNewsletterButton', 'Send an Email Campaign...');

define('LNG_NoNewsletters_HasAccess', ' Please click the "Create an Email Campaign" button to create one.');

define('LNG_Format_Text_Description', 'Text only emails are viewable in all email clients and are less likely to be reported as spam due to the lack of HTML code. This type of email will not be able to obtain results for open rates.');

define('LNG_Newsletter_Size_Over_EmailSize_Maximum', 'This email campaign is larger than %s. You will not be able to send this email campaign until you reduce the size of the images or attachments, or you can send the email campaign without embedded images.');

define('LNG_Editor_Upload_File', 'Upload a file from my computer');

define('LNG_Templates_User', 'Custom Email Templates');

define('LNG_SpamHeading_RuleBroken', 'Rule Broken');
define('LNG_SpamHeading_Score', 'Score');
define('LNG_Spam_Heading_intro_text', 'The <b>text</b> version of your email breaks the following spam rules:');
define('LNG_Spam_Heading_intro_html', 'The <b>HTML</b> version of your email breaks the following spam rules:');
define('LNG_Spam_Heading_intro_notspam_text', 'The <b>text</b> version of your email does not break any spam rules.');
define('LNG_Spam_Heading_intro_notspam_html', 'The <b>HTML</b> version of your email does not break any spam rules.');

define('LNG_Spam_Rating_Message', '<br />Your email rated <span style="font-size:15px; font-weight:bold">%s</span> out of a spam threshold of %s. %s');

define('LNG_Spam_Rating_notspam', 'This means there is a high chance your email will be delivered, but this is not guaranteed.');
define('LNG_Spam_Rating_alert', 'While your spam rating does not exceed the threshold, it is still recommended that you remove spam keywords before sending.');
define('LNG_Spam_Rating_spam', 'This means your email contains lots of spam related keywords. It is highly recommended you remove or replace these keywords before sending.');

define('LNG_Banned_Manage_NoList_Message', 'manage your suppression list');
define('LNG_Banned_Add_NoList_Message', 'add an email address to your suppression list');

define('LNG_Menu_Templates_Description', '\'Templates\' are pre-defined layouts on which new emails can be based.');

define('LNG_Menu_Home_Description', 'Navigate back to the home page');
define('LNG_Menu_Forms_Description', 'Website forms allow people to subscribe, unsubscribe, modify their details and forward your emails to friends.');
define('LNG_Menu_Users_Own_Description', 'Edit your personal account details');
define('LNG_Menu_Settings_Description', 'The system settings set up the main functionality of the application.');
define('LNG_Menu_Help_Description', 'View tutorials and articles on functionality and improving your email marketing results.');
define('LNG_Menu_Logout_Description', 'Logout of the system');
define('LNG_Logo_Description', 'Navigate back to the home page');

define('LNG_SpamKeywordsCheck', 'Check Your Email for Spam');
define('LNG_SpamKeywordsCheck_Button', 'Check your email campaign for spam keywords');

define('LNG_EmailClientCompatibility', 'Email Client Compatibility');
define('LNG_EmailClientCompatibility_Button', 'View your email in different email programs');

define('LNG_MiscellaneousOptions', 'Miscellaneous Options');

define('LNG_Recommended', '(Recommended)');

define('LNG_Search_HaveClicked', 'Has clicked');
define('LNG_Search_HaveNotClicked', 'Has not clicked');
define('LNG_Search_HaveOpened', 'Has opened');
define('LNG_Search_HaveNotOpened', 'Has not opened');

define('LNG_OriginalHTMLVersion', 'Original HTML Version');

define('LNG_DesignRules_Header', '<b>Email Formatting Rules</b><br/><br/>');

define('LNG_DesignRules_Intro', 'Below is a list of various email programs and the different formatting rules that may have been broken.<br/><br/>To see how an email will look in a particular email program, click the corresponding link above.');

define('LNG_Autoresponder_Count_None', '');
define('LNG_Autoresponder_Count_One', ' (1 Autoresponder)');
define('LNG_Autoresponder_Count_Many', ' (%s Autoresponders)');

define('LNG_MaximumFileSizeReached', 'You are trying to upload file larger than the server would allow you to upload. The maximum file size imposed by the server is: %s');

define('LNG_NewsletterDefaultTextContents', "Your email client cannot read this email.\nTo view it online, please go here: %%webversion%%\n\n\nTo stop receiving these emails:%%unsubscribelink%%");

define('LNG_DesignRules_NoRulesBroken', 'The email should display correctly.');

define('LNG_EmailValidation', 'Email Validation');

define('LNG_Format_', '');
define('LNG_FormType_', '');


/**
***************************
* Changed/Added in NX 1.3.1
***************************
*/

define('LNG_ShowFilteringOptionsLabel_Manage', 'Show Me:');
define('LNG_ShowFilteringOptionsLabel_Export', 'I Want to:');

/**
***************************
* Changed/Added in NX 1.3.2
***************************
*/
define('LNG_Users', "User Accounts");

/**
***************************
* Changed/Added in NX 1.3.3
***************************
*/
define('LNG_DesignRules_PrintNotFinishedLoading', 'The list of broken rules is not yet loaded. Please wait untill this list has completed loading before trying to print.');
define('LNG_DesignRules_LoadingRules', 'Loading rules for %s');

/**
***************************
* Changed/Added in NX 1.4
***************************
*/

define('LNG_WhatDoesThisMean', 'What does this mean?');

define('LNG_Loading_Stats','Loading, please wait...');

define('LNG_AlreadySentTo_Partial', '(Partially Sent)');
define('LNG_ResendTipHeading', 'Resend your email campaign');

define('LNG_Resend', 'Resend');

define('LNG_NoneOfTheFollowing', 'None of the following');

define('LNG_Loading_SendingPreview', 'Sending preview email...');

define('LNG_UserDateHeader', 'System Time: %s - (%s)');
define('LNG_LoggedInAs', 'You are logged in as "%s" | ');

define('LNG_Job_Resend', 'Resending');
define('LNG_JobResendSuccess', 'Your email campaign has been set up to re-send. It will send as soon as possible.');
define('LNG_JobResendFail', 'Your email campaign has not been set up to re-send. Please try again.');

define('LNG_CurrentUserReport', 'Current assigned user accounts: %s&nbsp;/&nbsp;admin accounts: %s&nbsp;(Your license key allows you to create %s more account)');
define('LNG_CurrentUserReport_Multiple', 'Current assigned user accounts: %s&nbsp;/&nbsp;admin accounts: %s&nbsp;(Your license key allows you to create %s more accounts)');

define('LNG_SendPreview_Loading', 'Sending preview...');

define('LNG_CronSkippedProblem', 'Your cron job has not been triggered for its last %s expected runs. You should contact your host to make sure that it is still functional.');

define('LNG_TestModeEnabled', 'Your application is currently in test mode. This means no emails will be sent when you try to send an email campaign.');

define('LNG_Spam_Guide_Heading', 'Check Your Email for Spam');

define('LNG_SmtpDefault', 'Use my default SMTP server');
define('LNG_SmtpDefaultSettings', 'Use my default mail settings');
define('LNG_SmtpCustom', 'Let me specify my own SMTP server details');

define('LNG_UseDefaultMail', 'Default Mail');
define('LNG_HLP_UseDefaultMail', 'Choose this option if you don\\\'t have your own SMTP server and want to use the default mail settings for your server. If you need to send more than a few hundred emails each week, many hosts require you to have your own SMTP server.');

define('LNG_Add_Banned_From_File', 'I want to upload a file that contains the email addresses/domains to suppress');

define('LNG_ProblemWithLocalMailServer', 'The local mail server did not accept your email. Please contact your host or systems administrator.');

define('LNG_OR', 'OR');

define('LNG_BounceError_NoDetails', 'No email account details were supplied. Please try again.');

/**
***************************
* Changed/Added in NX 1.4.1
***************************
*/
define('LNG_UseSMTP_User', LNG_UseSMTP);
define('LNG_HLP_UseSMTP_User', LNG_HLP_UseSMTP . ' The SMTP server configured here will override all other SMTP settings for this user.');
define('LNG_FileTooBig_Server', 'The file is too big and cannot be uploaded. It must be less than %s. If you need to increase this size, contact your systems administrator or web host and ask them to increase the PHP "upload_max_filesize" setting.');
define('LNG_FilePartiallyUploaded', 'The file was not uploaded correctly. Please try again.');
define('LNG_FileTooBig_NoSpace', 'The file was not uploaded as the server has run out of space or you have reached your disk quota. Please contact your systems administrator or web host.');
define('LNG_FileUploadProblem_NoTmpDir', 'The file was not uploaded as the server does not have a temporary directory set up correctly. Please contact your systems administrator or web host and ask them to set the PHP "upload_tmp_dir" setting.');

/**
***************************
* Changed/Added in v5.0
***************************
*/

define('LNG_DateSubscribed', 'Date Added');
define('LNG_VisibleFields','Visible Fields');
define('LNG_HLP_VisibleFields','Choose which fields to see when you\\\'re on the View Contacts page for this list.');
define('LNG_ShowTheseFields','Show These Fields');
define('LNG_SelectFields','Please select at least one field to show for this list.');

define('LNG_Subscribers', 'Contacts');

define('LNG_HLP_FilterFormat', 'This option will allow you to search for contacts who are subscribed in a particular format. To search for all contacts, leave this option set to \\\'Either Format\\\'');

define('LNG_Subscriber_Count_Many', ' (%s active contacts)');
define('LNG_Subscriber_Count_One', ' (1 active contact)');

define('LNG_HLP_FilterEmailAddress', 'This option will allow you to search for contacts with a particular domain name or part of their email address. To search for all subscribers, leave this option empty.');

define('LNG_HLP_FilterConfirmedStatus', 'This option will allow you to search for contacts based on whether they have confirmed their subscription or not. To search for all contacts, leave this option set to \\\'Both Confirmed and Unconfirmed\\\'');

define('LNG_HLP_ShowFilteringOptions', 'Choose the first option to export all contacts from your list. Choose the second option to see filter options so you can export contacts who only match your search criteria.');

define('LNG_HLP_FilterByDate', 'This option will allow you to filter contacts who have subscribed before, after or between particular dates. To search for all contacts, leave this option unticked.');

define('LNG_HLP_SubscribeRequestDate', 'The date and time that this contact requested to join this contact list.');
define('LNG_SubscribeRequestIP', 'Contact Request IP');
define('LNG_HLP_SubscribeRequestIP', 'The I.P. address of the computer from which this contact requested to join this contact list.');
define('LNG_SubscribeConfirmDate', 'Contact Confirm Date');
define('LNG_HLP_SubscribeConfirmDate', 'The date and time that this contact confirmed his request to join this contact list.');
define('LNG_SubscribeConfirmIP', 'Contact Confirm IP');
define('LNG_HLP_SubscribeConfirmIP', 'The I.P. address of the computer from which this contact confirmed joining this contact list.');

define('LNG_NoSubscribersOnList', 'There are no contacts on the list(s) you selected.');
define('LNG_NoSubscribersMatch', 'No contacts match your search criteria. Please try again.');
define('LNG_NoSubscribersOnSegment', 'There are no contacts in the segments(s) you selected.');

define('LNG_HLP_EmbedImages', 'This will embed the images from the content inside the email the contacts receive. This may make the email significantly larger but will allow contacts to view the content offline.');

define('LNG_HLP_SendTo_FirstName', 'If you have a custom field for the \\\'first name\\\' of the contact, choose it here so the newsletter can be addressed to the person individually.<br/>If you have a combined custom field for the persons name (that is, just one field called \\\'name\\\') then choose that custom field here.');

define('LNG_HLP_SendTo_LastName', 'If you have a custom field for the \\\'last name\\\' of the contact, choose it here so the newsletter can be addressed to the person individually.<br/>If you have a combined custom field for the persons name (that is, just one field called \\\'name\\\') then leave this option empty.');

define('LNG_HLP_ClickedOnLink', 'This option will allow you to filter contacts who have clicked on a particular link from an email campaign or autoresponder sent to this contact list. To search for all contacts, leave this option unticked.');

define('LNG_HLP_OpenedNewsletter', 'This option will allow you to filter contacts who have opened a particular email campaign or autoresponder sent to this contact list. To search for all contacts, leave this option unticked.');

define('LNG_NoUnsubscribeLinkInHTMLContent', 'No unsubscribe link was found in the html version of your email. It is recommended you add one so contacts can easily remove themselves from your contact list.');

define('LNG_NoUnsubscribeLinkInTextContent', 'No unsubscribe link was found in the text version of your email. It is recommended you add one so contacts can easily remove themselves from your contact list.');

define('LNG_HLP_Filter_Number', 'To restrict filtering of this field, you can use >, = and <. For example, to search for contacts who are under 25, enter < 25.');

define('LNG_HLP_Filter_Date', 'Choose the date or date range to filter contacts.<br/>To search between months, put * as the year.<br/>This only works when searching between dates.');

define('LNG_Newsletter_SendSize_Approximate', '<li>Each email will be about <b>%s</b> in size, which totals <b>%s</b> for the entire send</li>');

define('LNG_Menu_Members_Title', 'Create, view and delete contacts.');

define('LNG_Subscribers_Search_Step2', 'Search for contacts by entering search keywords and changing options in the form below. Learn how to search contacts more efficiently by reading <a href="#" onClick="LaunchHelp(\'%%WHITELABEL_INFOTIPS%%\',\'832\'); return false;">this article</a>.');

define('LNG_Format_HTML_Description', 'Your contacts must be using an HTML capable email client to be able to view this type of email. This type of email will produce the best results for open rates and link tracking.');
define('LNG_Format_TextAndHTML_Description', 'This will allow your contacts to view your email in any type of client they wish. This type of email will produce limited results for open rates and link tracking.');

define('LNG_Newsletter_Size_Over_EmailSize_Warning', 'This email campaign is larger than %s which means it may take a while for your contacts to download if you embed images.');

define('LNG_Newsletter_Size_Over_EmailSize_Warning_Send', 'This email campaign is larger than %s which means it may take a while for your contacts to download.');

define('LNG_Help_ListsManage', 'Contact lists are used to store details about subscribers or leads, which include their email address and other details such as name, company, age, etc.');

define('LNG_Import_Add_NoList_Message', 'import your contacts');
define('LNG_Export_Add_NoList_Message', 'export your contacts');
define('LNG_View_NoList_Message', 'view your contacts');
define('LNG_Remove_NoList_Message', 'remove contacts');
define('LNG_Add_NoList_Message', 'add contacts');

define('LNG_Menu_MailingLists_Description', 'View, add and edit your lists of contacts or leads.');
define('LNG_Menu_Members_Description', 'View or search for contacts across all of your lists.');
define('LNG_Menu_Newsletters_Description', 'View or edit your existing email campaigns.');
define('LNG_Menu_Autoresponders_Description', 'View or edit your existing autoresponder emails.');

define('LNG_AddSubscriber', 'Add&nbsp;Contact');
define('LNG_AddSubscriberTitle', 'Add Contact to this contact list');

define('LNG_ResendTipInfo', 'Your email campaign did not send to all of your contacts. Choose the \\\'Resend\\\' option to try and send to the rest of your contacts.');

define('LNG_HLP_ReplyToEmail', 'When a contact receives your email and clicks reply, which email address should that reply be sent to?<br/>You can change the default email address by editing your contact list and changing the \\\'Reply-To Email\\\'');

define('LNG_Menu_Segments_Manage', 'View Segments');
define('LNG_Menu_Segment_Description', 'View and create segmented lists of your contacts or leads.');

define('LNG_UnsubLinkPlaceholder', 'Unsubscribe me from this list');
define('LNG_NoLists', 'No contact lists are available. %s');

define('LNG_ListAssign', '&nbsp;Please contact your system administrator to assign you a contact list.');

define('LNG_Menu_Statistics_Lists', 'Contact List Statistics');

define('LNG_MailingLists', 'Contact Lists');
define('LNG_MailingList', 'Contact List');

define('LNG_Segments', 'Segments');

define('LNG_HLP_MailingList', 'To get started, please choose a contact list to work with. You can also select a contact list by double clicking on an option.');

define('LNG_SelectList', 'Please select at least one contact list before continuing.');
define('LNG_SelectOneList', 'Please select a contact list before continuing.');
define('LNG_SelectSegment', 'Please select at least one segment before continuing.');

define('LNG_Link_MailingListArchives', 'Link to Contact List Archives');

define('LNG_ListCreate', '&nbsp;Click the "Create a Contact List" button below to create one.');
define('LNG_CreateListButton', 'Create a Contact List...');

define('LNG_Menu_MailingLists_Title', 'Create, view and delete your contact lists.');

define('LNG_Autoresponder_NoLists', 'You need access to a contact list before you can create an autoresponder. %s');
define('LNG_Subscriber_NoLists', 'You need access to a contact list before you can %s. %s');

define('LNG_Menu_Statistics_Description', 'View reports for each email campaign you\'ve sent.');

define('LNG_MailingListDetails', 'Select a Contact List(s)');

define('LNG_HLP_SendFromName', 'Which person or company should be shown in the \\\'From Name\\\' field for this email?<br/>You can change the default name by editing your contact list and changing the \\\'List Owners Name\\\'');
define('LNG_HLP_SendFromEmail', 'Which email address should be shown in the \\\'From Email\\\' field for this email?<br/>You can change the default email address by editing your contact list and changing the \\\'List Owners Email\\\'');
define('LNG_HLP_BounceEmail', 'When an email bounces, or is rejected by the mail server, which email address should the error be sent to? If you plan to use the bounce handler, then make sure no other emails will be sent to this address.<br/>You can change the default email address by editing your contact list and changing the \\\'Bounce Email\\\'');

define('LNG_HLP_FilterStatus', 'This option will allow you to search for contacts based on their status on the contact list.<br/>Active contacts are those who have not bounced and have not unsubscribed from the contact list.<br/>The \\\'bounced\\\' status is for those who have been disabled on the contact list because they have had too many messages bounce from their email address, or have been detected as a hard bounce.<br/>The \\\'unsubscribed\\\' status is for those who have specifically unsubscribed from the contact list.<br/><br/>To search for all contacts, set this option set to \\\'Any Status\\\'');

define('LNG_Preview_CustomFieldsNotAltered', '<b>Please note:</b> Custom fields, unsubscribe links and recently selected attachments will not show up in this preview because they are contact specific.<br><br>To test your emails with custom fields, attachments and unsubscribe links, create a test contact list with yourself as a contact and send the email to that list.');

define('LNG_Menu_Members_Remove', 'Remove Contacts');
define('LNG_Menu_Members_Manage', 'View All Contacts');
define('LNG_Menu_Members_Import', 'Import Contacts From a File');
define('LNG_Menu_Members_Export', 'Export Contacts to a File');
define('LNG_Menu_Members_Add', 'Add a Contact');
define('LNG_Menu_MailingLists_Manage', 'View Contact Lists');
define('LNG_Menu_MailingLists_Create', 'Create a Contact List');
define('LNG_Menu_MailingLists_CustomFields', 'View Custom Fields');
define('LNG_Menu_Members_Banned_Manage', 'Email Suppression List');
define('LNG_Menu_Members_Banned_Add', 'Suppress an Email or Domain');

define('LNG_Menu_MailingLists_Create_Description', 'Create a new contact list which you can add contacts or leads to.');
define('LNG_Menu_MailingLists_CustomFields_Description', 'View and edit existing custom fields which you\'ve already created.');
define('LNG_Menu_MailingLists_Bounce_Description', 'Find and remove invalid email addresses from your lists.');
define('LNG_Menu_Members_Add_Description', 'Type the details of a new contact into a form and add them to your list.');
define('LNG_Menu_Members_Import_Description', 'Upload a file from your computer containing a list of contacts or leads.');
define('LNG_Menu_Members_Export_Description', 'Export contacts from one/more lists to a file which you can download.');
define('LNG_Menu_Members_Remove_Description', 'Unsubscribe or permanently remove contacts from your list.');
define('LNG_Menu_Members_Banned_Manage_Description', 'Suppressed emails remain in your lists but won\'t receive emails.');
define('LNG_Menu_Members_Banned_Add_Description', 'Add an email address or domain to the suppression list.');
define('LNG_Menu_Newsletters_Send_Description', 'Send an existing email campaign to your contact list.');
define('LNG_Menu_Newsletters_ManageSchedule_Description', 'See which email campaigns are scheduled to send and when.');
define('LNG_Menu_Newsletters_Create_Description', 'Create a new email campaign which you can then send to contacts.');
define('LNG_Menu_Templates_Create_Description', 'Create a new custom template');
define('LNG_Menu_Templates_Manage_BuiltIn_Description', 'View templates builtin to the application');
define('LNG_Menu_Templates_Manage_Description', 'Manage custom made templates');
define('LNG_Menu_Website_Forms', 'View Website Forms');
define('LNG_Menu_Website_Forms_Description', 'View and get the code for website forms that you\'ve already created.');
define('LNG_Menu_Create_Form', 'Create a Website Form');
define('LNG_Menu_Create_Form_Description', 'Build a subscription form which you can then place on your website.');

define('LNG_Menu_Templates', 'Templates');

define('LNG_Menu_Tools', 'Tools');
define('LNG_Menu_Tools_Description', 'Tools Menu');

define('LNG_Done','Go Back');

// Used for drop-down boxes
define('LNG_Select', 'select');


define('LNG_TooManyLists', 'You have too many lists and have reached your maximum. Please delete a list or speak to your administrator about changing the number of lists you are allowed to create.');

define('LNG_Menu_CustomFields_Create', 'Create a Custom Field');
define('LNG_Menu_CustomFields_Create_Description', 'Custom fields store contact details, such as name or phone number.');

define('LNG_AdvancedSearch', 'Advanced Search');

define('LNG_Paging_All', 'All');
define('LNG_Paging_Confirm_All', 'If you have a large number of records on this page it could take a long time to load. Continue?');

define('LNG_Menu_Tools_SystemInformation', 'System Information');
define('LNG_Menu_Tools_SystemInformation_Description', 'View information about your server');

define('LNG_ViewContacts', 'View&nbsp;Contacts');
define('LNG_SearchContacts', 'Search&nbsp;Contacts');

define('LNG_Header_Send_TestMode_WarningMessage_Admin', '<b>Important:</b> Your system is in "Test Mode". This means no emails will be sent when you send an email campaign. To disable test mode, go to the Settings page, choose "Email Settings" and disable the "Send In Test Mode" setting.');
define('LNG_Header_Send_TestMode_WarningMessage_User', '<b>Important:</b> Your system is in "Test Mode". This means no emails will be sent when you send an email campaign. To disable test mode, please contact your system administrator.');

define('LNG_Searchbox_Type_Prompt', 'Type here to search...');
define('LNG_Searchbox_List_Info_Simple', '(Only visible contact lists you have ticked will be selected)');
define('LNG_Searchbox_List_Info', '(Only visible contact lists/segments you have ticked will be selected)');

define('LNG_Editor_ChooseFileToUpload', 'Please choose a file to upload.');
define('LNG_Menu_Templates_Manage', 'Custom Email Templates');

define('LNG_Editor_WaitToLoad', 'Please wait for the editor to load before saving.');

define('LNG_CustomFieldsInsert_Editor', 'Insert a Custom Field');

define('LNG_TextWidthLimit_Explaination', 'If possible, keep your text to the left of the gray line above. <a href="#" onclick="LaunchHelp(\'%%WHITELABEL_INFOTIPS%%\',\'839\'); return false;" style="color:#999999;">Why</a>?');

define('LNG_Menu_Autoresponders_Statistics_Description', 'See statistics for autoresponder emails you\'ve setup.');
define('LNG_Menu_Statistics_Lists_Description', 'See how your contact lists are growing over time.');
define('LNG_Menu_Statistics_Users_Description', 'A complete overview of every user in the system, including emails sent.');
define('LNG_Menu_Search_Contacts', 'Search Contacts');
define('LNG_Menu_Contacts_Search_Description', 'Search for contacts across all of your lists and segments.');

define('LNG_ChangeFormat_Text', 'Update contacts to receive text campaigns');
define('LNG_ChangeFormat_HTML', 'Update contacts to receive HTML campaigns');

define('LNG_ChangeStatus_Confirm', 'Update contacts status to confirmed');
define('LNG_ChangeStatus_Unconfirm', 'Update contacts status to unconfirmed');

define('LNG_Status', 'Activity Status');
define('LNG_Format', 'Email Format');
define('LNG_FilterByDate', 'Date Added');

define('LNG_FilterFormat', LNG_Format);
define('LNG_FilterStatus', LNG_Status);

define('LNG_Pages', 'Pages');
define('LNG_GuideToFiltering', '<a href="#" onClick="LaunchHelp(\'%%WHITELABEL_INFOTIPS%%\',\'832\'); return false;">Learn more about filtering contacts.</a>');
define('LNG_SaveAndKeepEditing', 'Save &amp; Keep Editing');

define('LNG_Jan_Long', 'January');
define('LNG_Feb_Long', 'Feburary');
define('LNG_Mar_Long', 'March');
define('LNG_Apr_Long', 'April');
define('LNG_May_Long', 'May');
define('LNG_Jun_Long', 'June');
define('LNG_Jul_Long', 'July');
define('LNG_Aug_Long', 'August');
define('LNG_Sep_Long', 'September');
define('LNG_Oct_Long', 'October');
define('LNG_Nov_Long', 'November');
define('LNG_Dec_Long', 'December');

/**
***************************
* Changed/Added in v5.0.6
***************************
*/
define('LNG_Subscriber_Count_Active_Confirmed_Many', ' (%s active confirmed contacts)');
define('LNG_Subscriber_Count_Active_Confirmed_One', ' (1 active confirmed contact)');

/**
***************************
* Changed/Added in 5.5.0
***************************
*/

define('LNG_Menu_TriggerEmails', 'View Triggers');
define('LNG_Menu_TriggerEmails_Description', 'A trigger activates an action when a specific event occurs.');
define('LNG_Menu_Statistics_TriggerEmails', 'Trigger Statistics');
define('LNG_Menu_Statistics_TriggerEmails_Description', 'View statistics for triggers that you have setup.');

# For more information on the variables you can use for the date call please see http://www.php.net/date
define('LNG_TodaysDate', 'd - F - Y');

define('LNG_EnterBounceUsername', 'Please enter the username for the bounce email address.');
define('LNG_EnterBounceEmailAddress', 'Please enter the password for the bounce email address.');
define('LNG_UnableEvaluateExtraMailSettings', 'Unable to evaluate extra mail settings.');
define('LNG_InvalidExtraMailSettings', 'Invalid \"extra mail settings\" detected.');

define('LNG_UserActivityLogLabel', 'Recent Activity: ');

define('LNG_Second(s)', 'second(s)');
define('LNG_Minute(s)', 'minute(s)');

define('LNG_Owner', 'Owner');

define('LNG_Menu_Autoresponders_Create_Description', 'Create an email that is automatically sent after a specific time.');


/**
***************************
* Changed/Added in 5.5.3
***************************
*/
define('LNG_User_Total_CreditsLeft', 'You have %s total credits left.');
define('LNG_User_Monthly_CreditsLeft', 'You have %s of %s total credits left for this month.');

/**
*************************
* Changed/added in 5.6.0
*************************
*/

define('LNG_EnterBounceServer', 'Please enter the address of your mail server, such as mail.yourserver.com');

define('LNG_Pick_Contact_List', 'PICK CONTACT LIST');
define('LNG_Find_Mail_Server', 'FIND MAIL SERVER');
define('LNG_Find_Bounces', 'FIND BOUNCES');
define('LNG_Remove_Contacts', 'REMOVE CONTACTS');
define('LNG_Finished', 'FINISHED');

define('LNG_Bounce_Account_Type','Account Type');
define('LNG_Bounce_POP3_Account','POP3 Account (Recommended)');
define('LNG_Bounce_IMAP_Account','IMAP Account');
define('LNG_Bounce_Adv_Settings','Advanced Settings');
define('LNG_Bounce_Adv_Settings_Autodetect','Autodetect advanced settings (recommended)');
define('LNG_Bounce_Emp_Inbox','Empty Inbox When Done?');
define('LNG_Bounce_Emp_Inbox_Text','Empty the inbox after processing bounces');
define('LNG_Bounce_Test_Conn_Cont','Test Connection & Continue');
define('LNG_Bounce_Server_Desc','(Such as mail.company.com - confirm with your web host)');
define('LNG_Bounce_Auto_Process_Short', 'Process Bounces Automatically');
define('LNG_Bounce_Manual_Process_Short', 'Process Bounces Manually');
define('LNG_HLP_Bounce_Account_Type','Which type of email account is used to process your bounced emails? If you\'re unsure try choosing POP3 Account.');
define('LNG_HLP_Bounce_Adv_Settings','You may need to set extra options to connect to an email account for bounce processing. If so, unable this option and choose/fill in the required information below. If unsure, leave this ticked.');
define('LNG_HLP_Bounce_Emp_Inbox_Text','If ticked, all emails in the bounce account\'s inbox will be deleted every time bounce processing runs. You should tick this option if this email account is only used to process bounces.');

define('LNG_Upload', 'Upload');

define('LNG_Menu_Images_Manage', 'Image Manager');
define('LNG_Menu_Images_Manage_Description', 'Upload images from your computer to use when creating content for your emails.');

define('LNG_ApplicationSettings_Heading', 'Application&nbsp;Settings');
define('LNG_EmailSettings_Heading', 'Email&nbsp;Settings');
define('LNG_BounceSettings_Heading', 'Bounce&nbsp;Settings');
define('LNG_CreditSettings_Heading', 'Email&nbsp;Credit&nbsp;Settings');
define('LNG_CronSettings_Heading', 'Cron&nbsp;Settings');
define('LNG_SecuritySettings_Heading', 'Security&nbsp;Settings');
define('LNG_AddonsSettings_Heading', 'Addons&nbsp;Settings');

define('LNG_Spam_Check_Passed', 'Spam check passed.');
define('LNG_Spam_Check_Failed', 'Email Spam Check Failed');

define('LNG_CreditWarning_EmailSubject', 'Email credit with us');

define('LNG_Spam_Guide_Forced', 'Your administrator has enabled the "Force Spam Check" option on all email campaigns and autoresponders before they can be sent. Your message breaks the rules shown below. Please change your message to reduce your spam score before saving.');
define('LNG_Spam_Loading', 'Spam check in progress, please wait...');

define('LNG_EnterBouncePassword', 'Please enter the bounce server password.');

/**
*************************
* Changed/added in 5.6.6
*************************
*/
define('LNG_PreviewHTMLContent','Preview Content');

/**
*************************
* Changed/added in 5.7.0
*************************
*/
define('LNG_PrivateLabelSettings_Heading','Private&nbsp;Label&nbsp;Settings');
define('LNG_TrialUserLimitReached', 'You have reached your maximum number of trial users. You can still create normal user account.');

define('LNG_OverLimit_MaxEmails', 'You do not have enough total credit.');
define('LNG_OverLimit_PerMonth', 'You do not have enough monthly credit.');


/**
*************************
* Changed/added in 5.7.1
*************************
*/
define('LNG_CurrentUserReport_Unlimited', 'Current assigned user accounts: %s&nbsp;/&nbsp;admin accounts: %s&nbsp;(Your license key allows you to create unlimited accounts)');
define('LNG_AgencyCurrentUserReport', 'Admin accounts: <strong style="font-size:14px;">%s</strong>&nbsp;/&nbsp;Regular accounts: <strong style="font-size:14px;">%s</strong>&nbsp;/&nbsp;Trial accounts: <strong style="font-size:14px;">%s</strong>&nbsp;&#151;&nbsp;');
define('LNG_AgencyCurrentUserReport_CreateUnlimitedNormalUnlimitedTrial', 'Your license key allows you to create unlimited regular and trial users');
define('LNG_AgencyCurrentUserReport_CreateUnlimitedNormalFiniteTrial', 'Your license key allows you to create unlimited regular accounts and %s more trial account(s)');
define('LNG_AgencyCurrentUserReport_CreateFiniteNormalUnlimitedTrial', 'Your license key allows you to create %s more regular account(s) and unlimited trial account(s)');
define('LNG_AgencyCurrentUserReport_CreateNormalAndTrial', 'Your license key allows you to create %s more regular account(s) and %s more trial account(s)');
define('LNG_AgencyCurrentUserReport_NormalOnly', 'Your license only allows you to create %s more regular account(s)');
define('LNG_AgencyCurrentUserReport_TrialOnly', 'Your license only allows you to create %s more trial account(s)');

/**
*************************
* Changed/added in 5.7.3
*************************
*/
define('LNG_CannotVerifyAllImages_ExceedThreshold', 'Your newsletter contains more than %s images!');
define('LNG_CannotVerifyAllImages_OnlyThresholdImagesVerified', 'Only the first %s images were verified.');
define('LNG_CannotVerifyAllImages_SendSizeEstimated', 'Send size are estimated.');

/**
*************************
* Changed/added in 6.0.0
*************************
*/
define('LNG_Menu_UsersGroups', 'Users & Groups');
define('LNG_MenuDescription_UsersGroups', 'Manange your users and their group permissions.');
define('LNG_Menu_UsersGroups_ManageUsers', 'View User Accounts');
define('LNG_Menu_UsersGroups_CreateUser', 'Create a User Account');
define('LNG_Menu_UsersGroups_ManageGroups', 'View User Groups');
define('LNG_Menu_UsersGroups_CreateGroup', 'Create a User Group');

define('LNG_Menu_ContactLists', 'Contact Lists');
define('LNG_Menu_Contacts', 'Contacts');
define('LNG_Menu_EmailCampaigns', 'Email Campaigns');
define('LNG_Menu_Surveys', 'Surveys');
define('LNG_Menu_Autoresponders', 'Autoresponders');
define('LNG_Menu_Statistics', 'Statistics');

define('LNG_Menu_Surveys_View', 'View Surveys');
define('LNG_Menu_Surveys_Create', 'Create a Survey');
define('LNG_Menu_Surveys_Results', 'Survey Results');
define('LNG_Menu_Surveys_Responses_Browse', 'Browse Responses');
define('LNG_Menu_Surveys_Responses_Export', 'Export Responses');

define('LNG_Menu_Surveys_View_Description', 'Manage existing surveys which you\'ve already created.');
define('LNG_Menu_Surveys_Create_Description', 'Build a survey which you can then link to when creating an email campaign.');
define('LNG_Menu_Surveys_Results_Description', 'See who responded to your survey and which answers they selected.');
define('LNG_Menu_Surveys_Responses_Browse_Description', 'Browse survey responses one at a time using next and back buttons.');
define('LNG_Menu_Surveys_Responses_Export_Description', 'Download responses to a CSV file for further analysis.');

define('LNG_DynContentTagsInsert_Editor', 'Insert a Dynamic Content Tag...');
define('LNG_Close', 'Close');
define('LNG_ShowAvalableDynamicContent', 'Dynamic Content...');
